/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.blockentity;

import cloud.lemonslice.teastory.block.craft.StoveBlock;
import cloud.lemonslice.teastory.client.container.StoveContainer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.block.entity.NormalContainerBlockEntity;
import xueluoanping.teastory.block.entity.SyncedBlockEntity;
import xueluoanping.teastory.registry.BlockEntityRegister;
import xueluoanping.teastory.registry.ItemRegister;

public class StoveBlockEntity
extends NormalContainerBlockEntity {
    private int remainTicks = 0;
    private int fuelTicks = 0;
    private int workTicks = 0;
    private boolean lit = false;
    private int doubleClickTicks = 0;
    private final LazyOptional<ItemStackHandler> fuelInventory = LazyOptional.of(this::createFuelHandler);
    private final LazyOptional<ItemStackHandler> ashInventory = LazyOptional.of(this::createAshHandler);

    public StoveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegister.STOVE_TYPE.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fuelInventory.ifPresent(h -> h.deserializeNBT((Tag)tag.m_128469_("Fuel")));
        this.ashInventory.ifPresent(h -> h.deserializeNBT((Tag)tag.m_128469_("Ash")));
        this.fuelTicks = tag.m_128451_("FuelTicks");
        this.remainTicks = tag.m_128451_("RemainTicks");
        this.workTicks = tag.m_128451_("WorkTicks");
        this.lit = tag.m_128471_("Lit");
    }

    protected void m_183515_(CompoundTag tag) {
        this.fuelInventory.ifPresent(h -> tag.m_128365_("Fuel", h.serializeNBT()));
        this.ashInventory.ifPresent(h -> tag.m_128365_("Ash", h.serializeNBT()));
        tag.m_128405_("FuelTicks", this.fuelTicks);
        tag.m_128405_("RemainTicks", this.remainTicks);
        tag.m_128405_("WorkTicks", this.workTicks);
        tag.m_128379_("Lit", this.lit);
        super.m_183515_(tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (!this.m_58901_() && ForgeCapabilities.ITEM_HANDLER.equals(cap)) {
            if (side == Direction.DOWN) {
                return this.ashInventory.cast();
            }
            return this.fuelInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level worldIn, BlockPos pos, BlockState blockState, StoveBlockEntity stoveTileEntity) {
        if (stoveTileEntity.doubleClickTicks > 0) {
            --stoveTileEntity.doubleClickTicks;
        }
        if (!stoveTileEntity.isBurning()) {
            stoveTileEntity.addFuel();
        }
        if (stoveTileEntity.remainTicks > 0) {
            --stoveTileEntity.remainTicks;
            stoveTileEntity.inventoryChanged();
        } else if (worldIn instanceof ServerLevel && !stoveTileEntity.isBurning() && ((Boolean)blockState.m_61143_((Property)StoveBlock.LIT)).booleanValue()) {
            StoveBlock.setState(false, worldIn, pos);
            stoveTileEntity.inventoryChanged();
        }
    }

    private boolean addFuel() {
        if (this.isBurning()) {
            this.lit = true;
            return true;
        }
        ItemStack itemFuel = ((ItemStackHandler)this.fuelInventory.orElse((Object)new ItemStackHandler())).extractItem(0, 1, true);
        if (ForgeHooks.getBurnTime((ItemStack)itemFuel, (RecipeType)RecipeType.f_44108_) > 0) {
            this.fuelTicks = ForgeHooks.getBurnTime((ItemStack)itemFuel, (RecipeType)RecipeType.f_44108_) * 2;
            this.remainTicks = ForgeHooks.getBurnTime((ItemStack)itemFuel, (RecipeType)RecipeType.f_44108_) * 2;
            ItemStack cItem = ((ItemStackHandler)this.fuelInventory.orElse((Object)new ItemStackHandler())).getStackInSlot(0).getCraftingRemainingItem();
            if (!cItem.m_41619_()) {
                ((ItemStackHandler)this.fuelInventory.orElse((Object)new ItemStackHandler())).extractItem(0, 1, false);
                ((ItemStackHandler)this.fuelInventory.orElse((Object)new ItemStackHandler())).insertItem(0, cItem, false);
            } else {
                ((ItemStackHandler)this.fuelInventory.orElse((Object)new ItemStackHandler())).extractItem(0, 1, false);
            }
            ((ItemStackHandler)this.ashInventory.orElse((Object)new ItemStackHandler())).insertItem(0, new ItemStack((ItemLike)ItemRegister.ASH.get()), false);
            this.m_6596_();
            StoveBlock.setState(true, this.m_58904_(), this.m_58899_());
            this.lit = true;
            return true;
        }
        this.lit = false;
        return false;
    }

    public boolean isBurning() {
        return this.remainTicks > 0;
    }

    public NonNullList<ItemStack> getContents() {
        NonNullList list = NonNullList.m_122779_();
        this.fuelInventory.ifPresent(inv -> {
            ItemStack con = inv.getStackInSlot(0).m_41777_();
            con.m_41764_(1);
            for (int i = ((ItemStackHandler)this.fuelInventory.orElse((Object)new ItemStackHandler())).getStackInSlot(0).m_41613_(); i > 0; i -= 4) {
                list.add((Object)con);
            }
        });
        return list;
    }

    public int getRemainTicks() {
        return this.remainTicks;
    }

    public int getFuelTicks() {
        return this.fuelTicks;
    }

    public void setToLit() {
        this.lit = true;
    }

    public void singleClickStart() {
        this.doubleClickTicks = 10;
        this.m_6596_();
    }

    public boolean isDoubleClick() {
        return this.doubleClickTicks > 0;
    }

    private ItemStackHandler createAshHandler() {
        return new ItemStackHandler(){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_().equals(ItemRegister.ASH);
            }
        };
    }

    private ItemStackHandler createFuelHandler() {
        return new SyncedBlockEntity.SyncedItemStackHandler(this);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player p_39956_) {
        return new StoveContainer(id, playerInventory, this.f_58858_, this.f_58857_);
    }
}

